@extends('layouts.app')

@section('content')
<div id="smooth-wrapper">
    <div id="smooth-content">
        <main>
            <div class="it-about-3-area p-relative pt-190 pb-125">
                <img class="it-about-shape-1" src="assets/img/shape/about-1-1.png" alt="">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="it-section-title-box text-center mb-65" style="padding-top:50px;">
                                <span class="it-section-subtitle">معلوماتي الشخصية</span>
                                <h4 class="it-section-title it-split-in-right mb-0">عرض بيانات الحساب</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row justify-content-center">
    <div class="col-lg-8">
        <div class="card p-30 shadow-sm" class="row justify-content-center">
            
            <div class="d-flex justify-content-end mb-4">
                @if($user->image)
                    <img src="{{ asset('storage/' . $user->image) }}" alt="Avatar" class="rounded-circle" style="width:120px; height:120px; object-fit:cover;">
                @else
                    <img src="{{ asset('assets/img/avatar.jpg') }}" alt="Avatar" class="rounded-circle" style="width:120px; height:120px; object-fit:cover;">
                @endif
            </div>

            <div class="row text-right">
                <div class="col-md-6 mb-2">
                    <strong>الاسم الكامل :</strong> {{ $user->nom_prenom }}
                </div>
                <div class="col-md-6 mb-2">
                    <strong>البريد الإلكتروني :</strong> {{ $user->email }}
                </div>
                <div class="col-md-6 mb-2">
                    <strong>رقم بطاقة التعريف الوطنية :</strong> {{ $user->cin }}
                </div>
                <div class="col-md-6 mb-2">
                    <strong>تاريخ الإصدار :</strong> 
                    {{ $user->date_delivrance_cin ? \Carbon\Carbon::parse($user->date_delivrance_cin)->format('d-m-Y') : '---' }}
                </div>

                <div class="col-md-6 mb-2">
                    <strong>مكان الإصدار :</strong> {{ $user->lieu_delivrance_cin }}
                </div>
                <div class="col-md-6 mb-2">
                    <strong>الهاتف :</strong> {{ $user->tel ?? 'غير محدد' }}
                </div>
                <div class="col-12 mb-2">
                    <strong>العنوان :</strong> {{ $user->adresse ?? 'غير محدد' }}
                </div>
            </div>

            <!--div class="mt-4 text-start">
                <a href="" class="it-btn-orange">تعديل المعلومات</a>
            </!--div-->

        </div>
    </div>
</div>

                </div>
            </div>
        </main>
    </div>
</div>
@endsection
